#!/usr/bin/perl

# Copyright (C) 2005 John J. Chew, III <jjchew@math.utoronto.ca>
# All Rights Reserved

package TSH::Command::MISSing;

use strict;
use warnings;

use TSH::Utility;

our (@ISA) = qw(TSH::Command);

=pod

=head1 NAME

TSH::Command::MISSing - implement the C<tsh> MISSing command

=head1 SYNOPSIS

  my $command = new TSH::Command::MISSing;
  my $argsp = $command->ArgumentTypes();
  my $helptext = $command->Help();
  my (@names) = $command->Names();
  $command->Run($tournament, @parsed_arguments);
  
=head1 ABSTRACT

TSH::Command::MISSing is a subclass of TSH::Command.

=cut

=head1 DESCRIPTION

=over 4

=cut

sub initialise ($$$$);
sub new ($);
sub Run ($$@);

=item $parserp->initialise()

Used internally to (re)initialise the object.

=cut

sub initialise ($$$$) {
  my $this = shift;
  my $path = shift;
  my $namesp = shift;
  my $argtypesp = shift;

  $this->{'help'} = <<'EOF';
Use this command to see which player scores have yet to be entered
in a given division.
EOF
  $this->{'names'} = [qw(miss missing)];
  $this->{'argtypes'} = [qw(Round)];
# print "names=@$namesp argtypes=@$argtypesp\n";

  return $this;
  }

sub new ($) { return TSH::Utility::new(@_); }

=item $command->Run($tournament, @parsed_args)

Should run the command in the context of the given
tournament with the specified parsed arguments.

=cut

# TODO: should report table number (this involves orthogonalizing a function that maps (d,p,r) to (b,t)

sub Run ($$@) { 
  my $this = shift;
  my $tournament = shift;
  my ($round) = @_;
  my $round0 = $round-1;
  
  for my $dp (sort { $a->{'name'} cmp $b->{'name'} } $tournament->Divisions()) {
    my @done = ();
    my $datap = $dp->{'data'};
    for my $i (1..$#$datap) {
      next if $done[$i];
      if (!defined $datap->[$i]{'scores'}[$round0]) {
        my $opp = $datap->[$i]{'pairings'}[$round0];
	if ($opp) {
	  unless (defined $datap->[$opp]{'scores'}[$round0]) {
	    print $dp->FormatPairing($round0, $i);
	    }
          $done[$opp] = 1;
	  }
	else {
	  print TSH::Utility::TaggedName $datap->[$i];
	  }
        print "\n";
        }
      }
    }
  0;
  }
 
=back

=cut

1;
