# ratings2.pl - Additional Perl library of routines for manipulating NSA Elo ratings

# $Id: ratings2.pl,v 1.3 2005/10/05 12:37:24 jjc Exp jjc $
#
# $Log: ratings2.pl,v $
# Revision 1.3  2005/10/05 12:37:24  jjc
# minor bug fixes
#
# Revision 1.2  2005/01/06 22:56:56  jjc
# ! cleanup
#

# Copyright (C) 1997-2005 by John J. Chew, III <jjchew@math.utoronto.ca>
# All Rights Reserved

# WARNING: 
#
# Round-robin code is broken and no longer supported.
# Use tsh's pairing assigments to create appropriate pairings instead.

package ratings2;

$gqAccelerationBonuses = 1;
$gqClubMultipliers = 0;
$gqUseHomanPR = 1;
$gMaximumIterations = 25;

$gVersion = '1.2';

sub trunc ($) { int(0.5+100000*shift)/100000; }

sub SetMaximumIterations { $gMaximumIterations = $_[0]; }
sub UseClubMultipliers { $gqClubMultipliers = $_[0]; }
sub UseAccelerationBonuses { $gqAccelerationBonuses = $_[0]; }

# &CalculateRatings($players, $source_key, $first_round, $dest_key, $last_round, $ewins_key)
sub CalculateRatings { 
  my($psin, $source, $first, $dest, $last, $ewins) = @_;
  local($ps) = $psin;

  $first--; $last--;
  my($accel, $changed, $code, $excess, $games, $i, $multiplier, $n, $o, $p,
    $r, $sum, $target, $this_last, @unrated);

  # build list of unrated players, set feedback points to zero,
  # set effective rating for rated players to source rating
  @unrated = ();
  for my $p (@$ps) {
    if ($p->{$source}) { $p->{'effr'} = $p->{$source}; }
    else { push(@unrated, $p); }
    $p->{'feedback'} = 0;
    }

  # calculate ratings for all previously unrated players, using
  # an iterated performance rating algorithm.
  if ($#unrated >= 0) {
    if ($gqUseHomanPR) {
      my $i = 0;
      my $changed = 1;
      for my $p (@$ps) {
        if ($p->{$source}) 
	  { $p->{'curr'} = $p->{$source}; }
	else 
	  { $p->{'curr'} = 1500; }
        }
      while ($changed && $i++ < $gMaximumIterations) {
        $changed = 0;
        for my $p (@unrated) {
	  my $this_last = $#{$p->{'scores'}};
	  $this_last = $last if $last < $this_last;
	  if ($this_last >= $first) {
	    my $sumor = 0;
	    my $nor = 0;
	    my $maxor = 0;
	    for my $r ($first..$this_last) {
	      my $o = $p->{'opps'}[$r];
	      next if $o == -1;
	      $o = $ps->[$o];
	      die "$o->{'name'} has no current rating.\n" unless defined $o->{'curr'};
	      $sumor += $o->{'curr'};
	      $maxor = $o->{$source}+1 if $o->{$source}+1 > $maxor;
	      $nor++;
	      }
	    my $or = $nor ? $sumor/$nor : 500;
	    my $high = $maxor+400;
	    my $low = 500;
	    my $w = $p->{$ewins};
	    if ($w == 0) {
	      $w = 0.05*$p->{'rgames'};
# warn "$p->{'fname'} wins increased to $w.\n";
	      }
	    elsif ($w == $p->{'rgames'}) {
	      $w *= 0.95;
# warn "$p->{'fname'} wins decreased to $w.\n";
	      }
	    while ($high - $low > 1) {
	      my $mid = int(($low+$high)/2);
	      if (&main'outcome_cached($mid-$or) * $nor > $w) 
	        { $high = $mid; }
	      else 
	        { $low = $mid; }
	      }
	    if ($low != $p->{'curr'}) {
	      $p->{'newpr'} = $low;
	      $changed = 1;
	      }
	    }
	  }
#	for my $p (@unrated) {
#	  $p->{'newpr'} = 500 if $p->{'newpr'} < 500;
#	  }
	for my $p (@unrated) {
# warn "$p->{'fname'}: $p->{'curr'} -> $p->{'newpr'}\n";
	  $p->{'curr'} = $p->{'newpr'} if defined $p->{'newpr'};
	  }
        }
      }
    else {
      # give each player an initial rating equal to the average of their opps
      # and set up their performance rating calculation sub
      for my $p (@unrated) {
	$this_last = $#{$p->{'scores'}};
	$this_last = $last if $last < $this_last;
	if ($this_last >= $first) {
	  $sum = $n = 0;
	  $code = "sub main'ipr$p->{'id'} {";
	  for $r ($first..$this_last) {
	    $o = $p->{'opps'}[$r];
	    next if $o == -1;
	    $o = $ps->[$o];
	    $sum += $o->{$source};
	    $n++ if $o->{$source};
	    if ($o->{$source}) {
	      $code .= "&main'outcome_cached(\$_[0]-$o->{$source})+";
	      }
	    else {
	      $code .= 
		"&main'outcome_cached(\$_[0]-\$ps->[$o->{'id'}]->{'curr'})+";
	      }
	    }
	  $i = $p->{$ewins};
          if ($i == 0) {
#	    $i = 0.5;
	    $i = $p->{'rgames'}*0.05;  # 2002
	    } 
	  elsif ($i == $p->{'rgames'}) { 
#	    $i -= 0.5;
	    $i = $p->{'rgames'}*0.95;  # 2002
	    }
	  $code .= "-$i;} 1;";
	  eval $code || die "eval failed for: $code\n";
	  }

	if ($n) { $p->{'curr'} = $sum / $n; }
	else {
	  $p->{'curr'} = 500;
	  warn "$p->{'fname'} is unrated but did not play any rated players.\n";
	  }
	}
      
      # keep updating 'curr' until we attain stability
      for ($i=0,$changed=1; $changed && $i<$gMaximumIterations; $i++) {
	$changed = 0;
	for my $p (@unrated) {
  #	my $r = &main'search4("ipr$p->{'id'}", 0, 3000, 0.1);
	  my $r = &main'search("ipr$p->{'id'}", 0, 3000);
	  if ($r != $p->{'curr'}) {
	    $p->{'newpr'} = $r;
	    $changed = 1;
	    }
	  }
	for my $p (@unrated) {
	  $p->{'curr'} = $p->{'newpr'};
	  }
	}
      }

    # new rating is last iterated performance rating
    for $p (@unrated) { $p->{$dest} = $p->{'effr'} = $p->{'curr'}; }
    } # finished calculating initial ratings of unrated players

  # now calculate ratings for previously rated players
  for $p (@$ps) { next unless $p->{$source};
    $excess = 0;
    $games = 0;
    # this_last: last round to take into consideration
    $this_last = $#{$p->{'scores'}};
    $this_last = $last if $last < $this_last;

    $p->{$dest} = $p->{$source}; 
    # if we have any rounds to look at
    if ($this_last >= $first) {
      $excess = $p->{$ewins};
      for my $r ($first..$this_last) {
        my $o = $p->{'opps'}[$r];
        next if $o == -1;
        $excess -= &main'outcome_cached($p->{'effr'}-$ps->[$o]->{'effr'});
        $games++;
        }
      if (defined $p->{'rr'}) {
        $games += $#$ps * $p->{'rr'}[0];
        for my $o (@$ps) { next if $o eq $p;
	  $excess -= &main'outcome_cached($p->{'effr'}-$o->{'effr'}) * $p->{'rr'}[0];
          }
        }
      while ($excess) {
        $multiplier = &Multiplier($p->{'totalg'}, $p->{$dest});
#       $r = int(0.5 + $p->{$dest} + $multiplier * $excess);
        $r = $p->{$dest} + $multiplier * $excess; # 2002
# warn "$p->{'fname'}: $excess $p->{$dest} $r\n";
        if ($multiplier == &Multiplier($p->{'totalg'}, $r)) 
	  { $p->{$dest} = $r; last; }
        if ($p->{$dest} < 1800) { $target = 1800; }
        elsif ($p->{$dest} < 2000) { $target = $excess > 0 ? 2000 : 1799; }
        else { $target = 1999; }
        $excess -= ($target - $p->{$dest}) / $multiplier;
        $p->{$dest} = $target;
        }

      if (!$gqAccelerationBonuses) { $p->{'accel'} = 0; }
      else {
	# add acceleration bonuses
	$accel = $p->{$dest} - $p->{$source} - 5 * $games;
	if ($accel > 0) {
	  $p->{$dest} += $p->{'accel'} = $accel; 
# warn "$p->{'fname'}: accel + $accel = $p->{$dest}\n";
	  }
	else { $p->{'accel'} = 0; }

	# calculate feedback
#	if ($accel >= 20) {
	if ($accel > 0) { # 2002
#	  $accel = int($accel/20);
 	  $accel = $accel/20; # 2002
	  for $r ($first..$this_last) {
	    $o = $p->{'opps'}[$r];
	    next if $o == -1;
	    next unless $ps->[$o]{$source}; # 2002
	    $ps->[$o]{'feedback'} += $accel;
	    }
	  }
	}
# warn "$p->{'fname'}: $p->{$source} -> $p->{$dest}\n";
      }
    }

  # add on feedback
  for my $p (@$ps) { 
    $p->{$dest} += $p->{'feedback'}; 
# warn "$p->{'fname'}: feedback + $p->{'feedback'} = $p->{$dest}\n" if $p->{'feedback'};
    }

  # 2002: round now
  for my $p (@$ps) { 
    $p->{$dest} = int(0.5 + $p->{$dest});
    }
  }

# $multiplier = &Multiplier($games, $rating);
sub Multiplier { local($games, $rating) = @_;
  $games < 0 ? 0 : 
  ($games < 50
      ? $rating < 1800 ? 30 : $rating < 2000 ? 24 : 15
      : $rating < 1800 ? 20 : $rating < 2000 ? 16 : 10)
  / ($gqClubMultipliers ? 3 : 1);
  }

1;
