#!/usr/bin/perl

# Copyright (C) 2005 John J. Chew, III <jjchew@math.utoronto.ca>
# All Rights Reserved

package TSH::Command::RANDomscores;

use strict;
use warnings;

use TSH::Utility;

our (@ISA) = qw(TSH::Command);

=pod

=head1 NAME

TSH::Command::RANDomscores - implement the C<tsh> RANDomscores command

=head1 SYNOPSIS

  my $command = new TSH::Command::RANDomscores;
  my $argsp = $command->ArgumentTypes();
  my $helptext = $command->Help();
  my (@names) = $command->Names();
  $command->Run($tournament, @parsed_arguments);
  
=head1 ABSTRACT

TSH::Command::RANDomscores is a subclass of TSH::Command.

=cut

=head1 DESCRIPTION

=over 4

=cut

sub initialise ($$$$);
sub new ($);
sub Run ($$@);

=item $parserp->initialise()

Used internally to (re)initialise the object.

=cut

sub initialise ($$$$) {
  my $this = shift;
  my $path = shift;
  my $namesp = shift;
  my $argtypesp = shift;

  $this->{'help'} = <<'EOF';
Use this command to add a round of random scores to a division
for testing purposes.
EOF
  $this->{'names'} = [qw(rand randomscores)];
  $this->{'argtypes'} = [qw(Divisions)];
# print "names=@$namesp argtypes=@$argtypesp\n";

  return $this;
  }

sub new ($) { return TSH::Utility::new(@_); }

=item $command->Run($tournament, @parsed_args)

Should run the command in the context of the given
tournament with the specified parsed arguments.

=cut

# TODO: split this up into smaller subs for maintainability

sub Run ($$@) { 
  my $this = shift;
  my $tournament = shift;

  my $distrib =
    $config::rating_system && $config::rating_system =~ /^absp$/i
      ? 'absp' : 'nsa';

  for my $dp (@_) {
    $tournament->TellUser('irandok', $dp->Name());
    my $round1 = $dp->LeastScores() + 1;
    for my $p ($dp->Players()) {
      next if $p->GamesPlayed() >= $round1;
      next if $#{$p->{'scores'}} >= $#{$p->{'pairings'}};
      if ($p->{'pairings'}[$#{$p->{'scores'}}+1]) {
	push(@{$p->{'scores'}}, 
	  $distrib eq 'nsa'
	    # based on the NSA Club #3 2004-2005 season
	    ? int(130*log(($p->{'rating'}||1000)/75)
	      +rand(200)-100)
	    # based on nothing
	    : int(300+rand($p->{'rating'})));
	}
      else {
	push(@{$p->{'scores'}}, 50);
        }
      printf "%s: @{$p->{'scores'}}\n", (TSH::Utility::TaggedName $p);
      }
    $dp->Dirty(1);
    $dp->Update();
    }
  $tournament->TellUser('idone');
  }

=back

=cut

=head1 BUGS

Makes inappropriate use of Player.pm internals.

=cut

1;
