#!/usr/bin/perl

# Copyright (C) 2005 John J. Chew, III <jjchew@math.utoronto.ca>
# All Rights Reserved

package TSH::Command::LOOK;

use strict;
use warnings;

require 'dawg.pl';

use TSH::Utility;

our (@ISA) = qw(TSH::Command);

=pod

=head1 NAME

TSH::Command::LOOK - implement the C<tsh> LOOK command

=head1 SYNOPSIS

  my $command = new TSH::Command::LOOK;
  my $argsp = $command->ArgumentTypes();
  my $helptext = $command->Help();
  my (@names) = $command->Names();
  $command->Run($tournament, @parsed_arguments);
  
=head1 ABSTRACT

TSH::Command::LOOK is a subclass of TSH::Command.

=cut

=head1 DESCRIPTION

=over 4

=cut

sub initialise ($$$$);
sub new ($);
sub Run ($$@);

=item $parserp->initialise()

Used internally to (re)initialise the object.

=cut

sub initialise ($$$$) {
  my $this = shift;
  my $path = shift;
  my $namesp = shift;
  my $argtypesp = shift;

  $this->{'help'} = <<'EOF';
This command checks words for acceptability, if you have a dictionary
file installed.
EOF
  $this->{'names'} = [qw(look)];
  $this->{'argtypes'} = [qw(Words)];
# print "names=@$namesp argtypes=@$argtypesp\n";
  if (-r 'lib/words/twl98.dwg') {
    &dawg'open(*TWL98, 'lib/words/twl98.dwg');
    $this->{'dict'}{'TWL98'}++;
    }

  return $this;
  }

sub new ($) { return TSH::Utility::new(@_); }

=item $command->Run($tournament, @parsed_args)

Should run the command in the context of the given
tournament with the specified parsed arguments.

=cut

sub Run ($$@) { 
  my $this = shift;
  my $tournament = shift;
  my (@words) = @_;
  
  unless ($this->{'dict'}{'TWL98'}) 
    { $tournament->TellUser('elooknod'); return; }
  my $ok = 1;
  for my $word (@words) {
    if (&dawg'check(*TWL98, lc $word)) { 
#     print "'$word' is acceptable.\n"; 
      }
    else { 
#     print "'$word' is not acceptable.\n";
      $ok = 0; 
      }
    }
  printf "The play is%s acceptable.\n", $ok ? '' : ' not';
  }

=back

=cut

=head1 BUGS

Should support multiple dictionaries.

Should rewrite dawg.pl as a modern Perl module.

=cut

1;
