#!/usr/bin/perl

# Copyright (C) 2005 John J. Chew, III <jjchew@math.utoronto.ca>
# All Rights Reserved

package TSH::PairingCommand;

use strict;
use warnings;
use TSH::Utility;

our (@ISA) = qw(TSH::Command);

=pod

=head1 NAME

TSH::PairingCommand - abstraction of a C<tsh> pairing command

=head1 SYNOPSIS

This is a pure virtual class that exists solely to test for class membership.
See its parent class C<TSH::Command> for usage.
  
=head1 ABSTRACT

This Perl module is a virtual superclass for classes that provide
pairing commands for C<tsh>.

=cut

=head1 DESCRIPTION

This class defines no methods or variables.

=cut

=head1 BUGS

None known.

=cut

1;
