#!/usr/bin/perl

# Copyright (C) 2005 John J. Chew, III <jjchew@math.utoronto.ca>
# All Rights Reserved

package TSH::Command::PrePreSWiss;

use strict;
use warnings;

our (@ISA) = qw(TSH::Command);

=pod

=head1 NAME

TSH::Command::PrePreSWiss - implement the C<tsh> PrePreSWiss command

=head1 SYNOPSIS

  my $command = new TSH::Command::PrePreSWiss;
  my $argsp = $command->ArgumentTypes();
  my $helptext = $command->Help();
  my (@names) = $command->Names();
  $command->Run($tournament, @parsed_arguments);
  
=head1 ABSTRACT

TSH::Command::PrePreSWiss is a subclass of TSH::Command.

=cut

=head1 DESCRIPTION

=over 4

=cut

sub initialise ($$$$);
sub new ($);
sub Run ($$@);

=item $parserp->initialise()

Used internally to (re)initialise the object.

=cut

sub initialise ($$$$) {
  my $this = shift;
  my $path = shift;
  my $namesp = shift;
  my $argtypesp = shift;

  $this->{'help'} = <<'EOF';
Use the PrePreSWiss command to manually add a round of Swiss pairings
to a division based on the third preceding round, 
specifying the maximum number of allowable repeats.
This command was deprecated because the quality of its pairings
was significantly inferior to those generated by NewSwiss,
and because you really shouldn't be using such old rankings
to compute your pairings.
In the current version of tsh, PrePreSWiss simply calls NewSwiss.
For a still better algorithm, try ChewPair.
EOF
  $this->{'names'} = [qw(ppsw prepreswiss)];
  $this->{'argtypes'} = [qw(Repeats Division)];
# print "names=@$namesp argtypes=@$argtypesp\n";

  return $this;
  }

sub new ($) { return TSH::Utility::new(@_); }

=item $command->Run($tournament, @parsed_args)

Should run the command in the context of the given
tournament with the specified parsed arguments.

=cut

sub Run ($$@) { 
  my $this = shift;
  my $tournament = shift;
  my ($repeats, $dp) = @_;
  my $sr0 = $dp->LastPairedRound0() - 2;
  $tournament->TellUser('edeprec', 'NewSwiss');
  $dp->CheckRoundHasResults($sr0) or return;
  $tournament->TellUser('insok', $dp->Name(), $sr0+1, $repeats);
  $dp->PairSwiss($repeats, $sr0);
  }

=back

=cut

=head1 BUGS

None known.

=cut

1;
