#!/usr/bin/perl

# tshview.pl - CGI script to view tsh tournaments

use strict;
use warnings;
use CGI qw(:standard);
use lib qw(../lib/perl ./lib/perl /Users/jjc/local/tsh/lib/perl);
use TSH::Tournament;
use TSH::Utility;
use JavaScript::Serializable;

sub AskID (;$);
sub CacheIsFresh ($$);
sub CacheName ($);
sub Die ($);
sub FindMessages ();
sub FindRoot ();
sub GetNewJavaScript ($);
sub lint ();
sub Main ();
sub ModTime ($);
sub ProcessID ($$);
sub SendEmptyData ();
sub SendInitial ($$);
sub SendJavaScript ($$);
sub SendMessage ($$);
sub SendUpdate ($$$);
sub SendWrapperBottom ();
sub SendWrapperTop ($);
sub SetUserMessageCallback ($);
sub Warn ($);

Main;

sub AskID (;$) {
  my $message = shift;
  if (defined $message) { $message = "<p><font color=red>$message</font></p>"; }
  else { $message = ''; }
  print header,
    start_html('tshview: Choose An Event'),
    h1('tshview: Choose An Event'),
    $message,
    start_form,
    '<p>Event ID: ', textfield('id', '', 40, 80), ' ', submit('submit', 'Ok'), '</p>',
    end_form,
    end_html;
  }

=item $boolean = CacheIsFresh $tournament, $dir;

Return true if the JavaScript cache is still current.

=cut

sub CacheIsFresh ($$) {
  my $tournament = shift;
  my $dir = shift;
  my $fname = CacheName $dir;
  my $cachetime = (ModTime $fname) or return 0;
  return 0 if $cachetime < $tournament->Config()->LastModified();
  return 1;
  }

sub CacheName ($) {
  my $dir = shift;
  return "$dir/cache.js";
  }

sub Die ($) {
  my $message = shift;
  SendMessage 'error', $message;
  exit 1;
  }

sub FindMessages () {
  for my $dir ('../httpdocs/lib', '../lib', 'lib', '/Users/jjc/local/tsh/lib') {
    my $fn = "$dir/messages.txt";
    if (-r $fn) { $config::message_file = $fn; return; }
    }
  Die "$0: Can't find messages file.\n";
  }

sub FindRoot () {
  for my $choice ('../httpdocs/tsh', '../tsh', '../Documents/tsh') {
    if (-d $choice) { return $choice; }
    }
  Die "$0: Can't find local tsh directory.\n";
  }

sub GetNewJavaScript ($) {
  my $tournament = shift;
  # don't buffer error messages
  $| = 1;
  # try to load tournament
  eval { 
    $tournament->LoadConfiguration();
    $tournament->LoadDivisions();
    }; Die $@ if $@;
  # build new JavaScript
  my $modtime = $tournament->Config()->LastModified();
  my $js = '';
  $js .= "tsh_no_data=0;\n";
  $js .= "modtime=$modtime;\n";
  $js .= "newt=" . $tournament->ToJavaScript() . ";\n";
  $js .= "complete=1;\n";
  # send JavaScript
  return ($modtime, $js);
  }

sub lint () {
  lint;
# $config::event_date = undef;
# $config::event_name = undef;
  }

sub Main () {
  my $id = param('id');
  my $turn = param('turn');
  
  FindMessages;
  if (defined $id) { ProcessID $id, $turn; }
  else { AskID; }
  }

sub ModTime ($) {
  my $fn = shift;
  return undef unless defined $fn;
  my (@stat) = stat $fn;
  return $stat[9];
  }

sub ProcessID ($$) {
  my $id = shift;
  my $turn = shift;
  $id =~ s/\.{2,}/./g;
  $id =~ s/[^-.\w\/]//g;
  my $root = FindRoot;
  my $dir = "$root/$id";
  my $tshfile = "$dir/config.tsh";
  unless (-d $dir) {
    AskID "There is no event named `$id'.";
    exit 0;
    }
  my $tournament;
  eval { $tournament = new TSH::Tournament($dir); }; Die $@ if $@;
  SetUserMessageCallback $tournament;
  if (my $since = param('since')) 
    { SendUpdate $tournament, $dir, $since; }
  else 
    { SendInitial $tournament, $dir; }
  }

sub SendEmpty () {
  print "tsh_no_data = 1;\n"
  }

sub SendInitial ($$) {
  my $tournament = shift;
  my $dir = shift;
  SendWrapperTop $tournament;
  SendJavaScript $tournament, $dir;
  SendWrapperBottom;
  }

sub SendJavaScript ($$) {
  my $tournament = shift;
  my $dir = shift;
  my $fn = CacheName $dir;
  my $fh;
  if (CacheIsFresh($tournament, $dir)) {
    local($/);
    open $fh, "<$fn" or Die "Can't read cache: $!\n";
    my $js = <$fh>;
    close $fh;
    print $js;
    }
  else {
    my ($modtime, $js) = GetNewJavaScript($tournament);
    TSH::Utility::ReplaceFile($fn, $js);
    utime $modtime, $modtime, $fn;
    print $js;
    }
  }

sub SendMessage ($$) {
  my $type = shift;
  my $message = shift;
  if (param('since')) {
    $message =~ s/([\\'\n])/\\$1/g;
    print "$type += '$message'\n";
    }
  else {
    my (%escape) = ('<' => '&lt;', '>' => '&gt;', '&' => '&amp;');
    $message =~ s/([&<>])/$escape{$1}/g;
    $message =~ s/([\\'\n])/\\$1/g;
    print <<"EOF";
<script type="text/javascript"><!--
statusdiv = GetThingByID('status');
statusdiv.innerHTML += '<p>$message</p>';
--></script>
EOF
    }
  }

sub SendUpdate ($$$) {
  my $tournament = shift;
  my $dir = shift;
  my $since = shift;
  if ($since >= $tournament->Config()->LastModified()) {
    SendEmptyData;
    }
  else {
    SendJavaScript $tournament, $dir;
    }
  }

sub SendWrapperBottom () {
  print <<"EOF";
tournament=newt;
Initialise();
</script>
</body>
</html>
EOF
  }

sub SendWrapperTop ($) {
  print header;
  print <<"EOF";
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" "http://www.w3.org/TR/REC-html40/loose.dtd">
<html>
<head>
<title>tshview</title>
<link rev=made href="mailto:jjchew\@math.utoronto.ca">
<meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1">
<style type="text/css"><!--
div, h1, h2, h3, p, span, td {
  font-family: "Lucida Bright", Helvetica, sansserif;
  }
div#status, span.score {
  font-family: "Courier", monospace;
  }
span.opp, span.score {
  font-size: 80%; 
  }
td.win {
  background-color: #c0ffc0;
  }
td.loss {
  background-color: #ffc0c0;
  }
--></style>
<script type="text/javascript">
var maindiv;
var error = '';
var warning = '';

function GetThingByID(id) {
  if( document.layers ) { // NN 4
    return document.layers[id]; }
  if( document.getElementById ) { // W3C IE5 NN6 Mozilla Opera 
    return document.getElementById(id); }
  if( document.all ) { // IE4
    return document.all[id]; }
  if( document[id] ) { // NN ?
    return document[id]; }
  return false;
  }

function Initialise () {
  maindiv = GetThingByID('main');
  var title = tournament.config['event_name'] + ', ' + tournament.config['event_date'];
  var s = '<h1>' + title + '</h1>';
  document.title = title;
  var cell;
  var div;
  var ms;
  var name;
  var op;
  var os;
  var p;
  var r;
  var r0;
  var pnum;
  var wltype;
  for (var dnum in tournament.divisions) {
    div = tournament.divisions[dnum];
    s += "<h2>Division "+div.name+"</h2>";
    s += "<table class=division>";
    s += "<tr><th>#</th><th>Player</th>";
    for (r=1; r<=tournament.config.max_rounds; r++) {
      s += "<th>Rd. "+r+"</th>";
      }
    s += "</tr>";
    for (pnum=1; pnum<div.players.length; pnum++) {
      s += "<tr>";
      s += "<td>" + pnum + "</td>";
      p = div.players[pnum];
      name = p["name"];
      s += "<td>" + name + "</td>";
      for (r=1; r<=tournament.config.max_rounds; r++) {
        r0 = r - 1;
	ms = p.scores[r0];
	op = p.pairings[r0];
	cell = "";
	wltype = "";
	if (op === undefined) { 
	  wltype="none";
	  cell = "<span class=score>-</span>" 
	  }
	else if (op == 0) {
	  wltype = "bye";
	  cell = "<span class=bye>bye</bye>";
	  }
	else { 
	  cell = "<span class=opp>" + op + "</span>"; 
	  cell += " ";
	  os = div.players[op].scores[r0];
	  if (ms === undefined) { ms = '?'; wltype = "undefined"; }
	  if (os === undefined) { os = '?'; wltype = "undefined"; }
	  if (wltype === "") {
	    if (ms > os) { wltype = "win"; }
	    else if (ms < os) { wltype = "loss"; }
	    else { wltype = "tie"; }
	    }
	  cell += "<span class=score>" + ms + "&ndash;" + os + "</span>";
	  }
	s += "<td class=" + wltype + ">" + cell + "</td>";
	}
      s += "</tr>";
      }
    s += "</table>";
    }
  maindiv.innerHTML = s;
  }
</script>
</head>
<body bgcolor=white>
<noscript>
You must have JavaScript enabled to view this content.
</noscript>
<div id=status>
Loading...
</div>
<div id=main>
&nbsp;
</div>
<script type="text/javascript">
EOF
  }

sub SetUserMessageCallback ($) {
  my $tournament = shift;
  my $um = $tournament->UserMessage();
  $um->SetErrorFilter(\&UserMessageCallback);
  $um->SetNoteFilter(\&UserMessageCallback);
  $um->SetWarningFilter(\&UserMessageCallback);
  }

=item UserMessageCallback($code, $type, $message);

Callback subroutine used by UserMessage.pm.

=cut

sub UserMessageCallback ($$$) {
  my $code = shift;
  my $type = shift;
  my $message = shift;

  return if $type eq 'note';
  SendMessage $type, "$message [$code]";
  }

sub Warn ($) {
  my $message = shift;
  SendMessage 'warning', $message;
  }

=head1 BUGS

=over 4

=item AskID() should give a popup list of choices.

=item Some of the code (AskID, ProcessID) is shared with showgcg.pl and should be separated out into a module.

=back

=cut
