#!/usr/bin/perl

# tshview.pl - CGI script to view tsh tournaments

# TODO: list players by board/table
# TODO: boards mode doesn't do background colour in opera/firefox?

use strict;
use warnings;
use CGI qw(:standard);
use lib qw(../lib/perl ./lib/perl /Users/jjc/local/tsh/lib/perl);
use TSH::Tournament;
use TSH::Utility;

sub AskID (;$);
sub CacheIsFresh ($);
sub CacheName ($);
sub Die ($);
sub FindMessages ();
sub FindRoot ();
sub GetNewJavaScript ($);
sub GetTournament ($);
sub HTMLJSQuote ($);
sub JSCompress ($\%);
sub JSQuote ($);
sub lint ();
sub Main ();
sub ModTime ($);
sub ProcessID ($);
sub SendEmptyData ();
sub SendIDRequest ($);
sub SendInitial ($);
sub SendJavaScript ($$);
sub SendMessage ($$);
sub SendUpdate ($$);
sub SendWrapperBottom (\%);
sub SendWrapperTop (\%);
sub SetUserMessageCallback ($);
sub Warn ($);

Main;

=head1 DESCRIPTION

=head2 CGI API

This script uses the following CGI parameters.

=over 4

=item x=1

Set to indicate that the client is an established AJAX client.

=item id=ID

Gives the id (relative path) of the tournament being viewed.

=item since=EPOCH

When requesting an update, specifies the time (in seconds since the Unix
epoch) when the client last received an update.


=back

=cut

=head2 SUBROUTINES

=over 4

=cut

=item $cachename = CacheIsFresh $tournament;

If the JavaScript cache is still current, return its name; else return undef.

=cut

sub CacheIsFresh ($) {
  my $tournament = shift;
  my $dir = $tournament->Path();
  my $fname = CacheName $dir;
  my $cachetime = (ModTime $fname) or return 0;
  return undef if $cachetime < $tournament->Config()->LastModified();
  return $fname;
  }

sub CacheName ($) {
  my $dir = shift;
  return "$dir/cache.js";
  }

sub Die ($) {
  my $message = shift;
  SendMessage 'error', $message;
  exit 1;
  }

sub FindMessages () {
  for my $dir ('../httpdocs/lib', '../lib', 'lib', '/Users/jjc/local/tsh/lib') {
    my $fn = "$dir/messages.txt";
    if (-r $fn) { $config::message_file = $fn; return; }
    }
  Die "$0: Can't find messages file.";
  }

sub FindRoot () {
  for my $choice ('../httpdocs/tsh', '../tsh', '../Documents/tsh', '/Users/jjc/local/tsh') {
    if (-d $choice) { return $choice; }
    }
  Die "$0: Can't find local tsh directory.";
  }

sub GetNewJavaScript ($) {
  my $tournament = shift;
  # don't buffer error messages
  $| = 1;
  # try to load tournament
  eval { 
    $tournament->LoadConfiguration();
    $tournament->LoadDivisions();
    }; Die $@ if $@;
  # build new JavaScript
  my $modtime = $tournament->Config()->LastModified();
  my $js = "";
  $js .= "modtime=$modtime;\n";
  $js .= "newt=" . $tournament->ToJavaScript() . ";\n";
  $js .= "t=newt;\n";
  $js .= "Update();\n";
  # send JavaScript
  return ($modtime, $js);
  }

sub GetTournament ($) {
  my $id = shift;
  $id =~ s/\.{2,}/./g; 
  my $root = FindRoot;
  my $dir = "$root/$id";
  return undef unless -d $dir;
  my $tournament;
  eval { $tournament = new TSH::Tournament($dir); };
  return undef if $@;
  SetUserMessageCallback $tournament;
  return $tournament;
  }

sub HTMLJSQuote ($) {
  my $s = shift;
  my (%escape) = ('<' => '&lt;', '>' => '&gt;', '&' => '&amp;');
  $s =~ s/([&<>])/$escape{$1}/g;
  $s = JSQuote($s);
  return $s;
  }

sub JSCompress ($\%) {
  my $js = shift;
  return $js;
  my $dictp = shift;
  $js =~ s/\s*\n\s+/\n/g;
  $js =~ s/\n\/\/.*//g;
  # try a few risky ones
  $js =~ s/\s*\)\s*\{ */){/g;
  $js =~ s/;\s+}/;}/g;
  $js =~ s/{\/\/.*/{/g;
  $js =~ s/\nif\s*\(\s*/if(/g;
  $js =~ s/\s*(=|==|===|(?:[-+]|&&|\|\|)=?)\s*/$1/g;
  # end risky
  $js =~ s/([;{}])\n/$1/g;
  $js =~ s/(JC_\w+)/'J'.($dictp->{$1}||($dictp->{$1}=++$dictp->{'_count'}))/ge;
  return $js;
  }

sub JSQuote ($) {
  my $s = shift;
  return '' unless defined $s;
  $s =~ s/([\\'\n])/\\$1/g;
  return $s;
  }

sub lint () {
  lint;
# $config::event_date = undef;
# $config::event_name = undef;
  }

sub Main () {
  my $id = param('id');
  my $since = param('since');
  my $x = param('x');
  my $p = param('p');
  
  FindMessages;
  print header;
  my $tournament = GetTournament $id;
  if ($x) { # established connection
    if ($tournament) {
      if ($p) { # photo request
	die;
	}
      elsif ($since) { SendUpdate $tournament, $since; }
      else { SendInitial $tournament; }
      }
    else {
      SendIDRequest $id;
      }
    }
  else {
    my %compression_dict;
    SendWrapperTop %compression_dict;
    if ($tournament) { SendInitial $tournament; }
    else { SendIDRequest ''; }
    SendWrapperBottom %compression_dict;
    }
  }

sub ModTime ($) {
  my $fn = shift;
  return undef unless defined $fn;
  my (@stat) = stat $fn;
  return $stat[9];
  }

sub SendEmpty () {
  }

sub SendIDRequest ($) {
  my $badid = shift;
  print "NeedID('", JSQuote($badid), "');\n";
  }

sub SendInitial ($) {
  my $tournament = shift;
  SendJavaScript $tournament, 0;
  }

  # TODO: should only send changed players
sub SendJavaScript ($$) {
  my $tournament = shift;
  my $since = shift;
  my $dir = $tournament->Path();
  if ($since) { Die "not implemented (since $since)"; }
  my $fn = CacheName $dir;
  my $fh;
  for my $key (qw(div mode)) {
    my $value = param($key);
    $value = '' unless defined $value;
    print "p.$key='", JSQuote($value), "'\n";
    }
  if (CacheIsFresh($tournament)) {
    local($/);
    open $fh, "<$fn" or Die "Can't read cache: $!";
    my $js = <$fh>;
    close $fh;
    print $js;
    }
  else {
    my ($modtime, $js) = GetNewJavaScript($tournament);
    eval {
      TSH::Utility::ReplaceFile($fn, $js);
      utime $modtime, $modtime, $fn;
      }; # might fail due to bad perms
    print $js;
    }
  }

sub SendMessage ($$) {
  my $type = shift;
  my $message = shift;
  if (param('since')) {
    $message =~ s/([\\'\n])/\\$1/g;
    print "$type += '$message'\n";
    }
  else {
    $message = JSQuote $message;
    print <<"EOF";
statusDiv.innerHTML += '<p>$message</p>';
EOF
    }
  }

sub SendUpdate ($$) {
  my $tournament = shift;
  my $since = shift;
  # is this really necessary?
  if ($since >= $tournament->Config()->LastModified()) {
    SendEmptyData;
    }
  else {
    SendJavaScript $tournament, $since;
    }
  }

sub SendWrapperBottom (\%) {
  my $dictp = shift;
  my $js1 = <<"EOF";
EOF
  $js1 = JSCompress $js1, %$dictp;
  print <<"EOF";
$js1;
</script>
</body>
</html>
EOF
  }

sub SendWrapperTop (\%) {
  my $dictp = shift;
  my $js1 = <<"EOF";
var JC_mainDiv;
var statusDiv;
var error = '';
var warning = '';
var newt;
var modtime;
var t;
var p = new Object(); // CGI parameters of interest
var JC_XHRList = new Array();

var JC_XMLHttpFactories = [
  function () {return new XMLHttpRequest()},
  function () {return new ActiveXObject("Msxml2.XMLHTTP")},
  function () {return new ActiveXObject("Msxml3.XMLHTTP")},
  function () {return new ActiveXObject("Microsoft.XMLHTTP")}
];

var JC_mode_dispatch = [
  {
    'code':'scores',
    'title':'Scores',
    'handler':function(){return JC_RenderRoundsTable(JC_RenderScoresCell)}
  },
  {
    'code':'p12',
    'title':'1st/2nd',
    'handler':function(){return JC_RenderRoundsTable(JC_RenderFirstsCell)}
  },
  {
    'code':'boards',
    'title':'Boards',
    'handler':function(){return JC_RenderRoundsTable(JC_RenderBoardsCell)}
  },
  {
    'code':'tables',
    'title':'Tables',
    'handler':function(){return JC_RenderRoundsTable(JC_RenderTablesCell)}
  },
  {
    'code':pairings,
    'title':'Pairings',
    'handler':function(){return JC_RenderPairingsTable()}
  }
  ];

function JC_ChooseEvent() {
  var JC_id = JC_ChooseEventForm.id.value;
  if (JC_id.length > 256) {
    JC_id = JC_id.substr(0, 256);
    }
  JC_id = encodeURI(JC_id);
  var JC_url = window.location.protocol+"//"+window.location.host+window.location.pathname;
// alert("request("+JC_id+","+JC_url+")");
  JC_SendHTTPRequest(JC_url,JC_ChooseEventCallback,"x=1&id="+JC_id);
  }

function JC_ChooseEventCallback(JC_req) {
// statusDiv.innerHTML += JC_req.responseText;
  try {
    eval (JC_req.responseText);
    }
  catch (e) {
    alert("Callback failed ("+e+")");
    }
  JC_XHRFree(JC_req);
  }

function JC_CreateXMLHTTPObject() {
  var JC_xmlhttp = false;
  var JC_e;
  var JC_i;
  for (var JC_i=0;JC_i<JC_XMLHttpFactories.length;JC_i++) {
    try{
      JC_xmlhttp = JC_XMLHttpFactories[JC_i]();
      }
    catch(JC_e){
      continue;
      }
    break;
    }
  return JC_xmlhttp;
  }

function JC_GetDivisionByName(JC_dname) {
  JC_dname = JC_dname.toUpperCase();
  for (var JC_i=0;JC_i<t.divisions.length;JC_i++) {
    if (JC_dname==t.divisions[JC_i].name) {
      return t.divisions[JC_i];
      }
    }
  return undefined
  }

function JC_GetModeHandler() {
  for (var JC_i=0;JC_i<JC_mode_dispatch.length;JC_i++) {
    if (JC_mode_dispatch[JC_i].code == p.mode) {
      return JC_mode_dispatch[JC_i].handler;
      }
    }
  return undefined;
  }

function JC_GetThingByID(JC_id) {
  if( document.layers ) { // NN 4
    return document.layers[JC_id]; }
  if( document.getElementById ) { // W3C IE5 NN6 Mozilla Opera 
    return document.getElementById(JC_id); }
  if( document.all ) { // IE4
    return document.all[JC_id]; }
  if( document[JC_id] ) { // NN ?
    return document[JC_id]; }
  return false;
  }

function NeedID(JC_badid) {
  if (JC_badid) {
    statusDiv.innerHTML = "<p>"+JC_HTMLQuote(JC_badid)+" is not a valid tournament ID. Please try again.</p>";
    }
  else {
    statusDiv.innerHTML = "<p>Please enter a tournament ID.</p>";
    }
  JC_mainDiv.innerHTML = '<form method="post" onsubmit="JC_ChooseEvent(); return false;" name=JC_ChooseEventForm><p>Event ID: <input type="text" name="id" size="40" maxlength="80" /> <input type="submit" name="submit" value="Choose" /></p></form>'; }

function JC_HTMLQuote(s) {
  return "Notyet("+s+")";
  }

function JC_PadPlayerNumber(JC_div,JC_pn) {
  return JC_ZeroPad(JC_pn,(JC_div.players.length+'').length);
  }

function JC_RenderBoardsCell(JC_div,JC_p,JC_r) {
  var JC_r0 = JC_r - 1;
  var JC_b;
  var JC_colour;
  var JC_maxb = Math.floor(JC_div.players.length/2);
  var JC_on = JC_p.pairings[JC_r0];
  var JC_style = 'board';
  var JC_text;

  if (JC_p.etc && JC_p.etc.board) { JC_b = JC_p.etc.board[JC_r0]; }
  if (JC_b === undefined) {
    JC_style = 'empty';
    }
  JC_b = JC_ZeroPad(JC_b,(JC_maxb+'').length);
  JC_colour = Math.floor(240*JC_b/JC_maxb).toString(16);
  if (JC_colour.length == 1) {
    JC_colour = '0' + JC_colour;
    }

  return "<td class="
    + JC_style
    + JC_RenderPlayerTitle(JC_div,JC_on)
    + ' bgcolor="#ff'+JC_colour+JC_colour+'"'
    + '><span class=opp>'
    + JC_PadPlayerNumber(JC_div,JC_on)
    + '</span> <span class=board>'
    + JC_b
    + '</span></td>';
  }

function JC_RenderFirstsCell(JC_div,JC_p,JC_r) {
  var JC_r0 = JC_r - 1;
  var JC_p12 = JC_p.etc.p12[JC_r0];
  var JC_oname = '';
  var JC_on = JC_p.pairings[JC_r0];
  var JC_style;
  var JC_text;
  if (JC_p12 === undefined) { 
    JC_p12 = 4;
    }
  JC_style = ['p0','p1','p2','p3','p4'][JC_p12];
  JC_text = ['-','1st','2nd','draw','?'][JC_p12];
  if (JC_text === undefined) {
    JC_style = 'p4';
    JC_text = '?';
    }

  return "<td class="
    + JC_style
    + JC_RenderPlayerTitle(JC_div,JC_on)
    + '><span class=opp>'
    + JC_PadPlayerNumber(JC_div,JC_on)
    + '</span> <span class=p12>'
    + JC_text
    + '</span></td>';
  }

function JC_RenderNavBar() {
  var JC_amode;
  var JC_adiv;
  var JC_s = '';
  var JC_title;
  // First the division choice
  JC_s += "<div class=nav><span class=label>Division</span>";
  for (var JC_i=0;JC_i<t.divisions.length;JC_i++) {
    JC_adiv = t.divisions[JC_i].name;
    if (p.div == JC_adiv) {
      JC_s += " <span class=sel>"+p.div+"</span>";
      }
    else {
      JC_s += ' <a href="#" onclick="p.div='+"'"+JC_adiv+"';Update();return false;"+'">'+JC_adiv+"</a>";
      }
    }
  // Then the view (mode) choice
  JC_s += " <span class=label>View</span>";
  for (var JC_i=0;JC_i<JC_mode_dispatch.length;JC_i++) {
    JC_amode = JC_mode_dispatch[JC_i];
    JC_title = JC_amode.title;
    if (JC_amode.code == p.mode) {
      JC_s += " <span class=sel>"+JC_title+"</span>";
      }
    else {
      JC_s += ' <a href="#" onclick="p.mode='+"'"+JC_amode.code+"';Update();return false;"+'">'+JC_title+"</a>";
      }
    }
  JC_s += "</div>";
  return JC_s;
  }

function JC_RenderPairingsTable() {
  var JC_s = '';
  JC_s += 'not yet';
  return JC_s;
  }

function JC_RenderPlayerCells(JC_div,JC_pnum) {
  var JC_p = JC_div.players[JC_pnum];
  var JC_s = '';
  JC_s += "<td>" + JC_PadPlayerNumber(JC_div,JC_pnum)
    + "</td>";
  JC_s += "<td>" + JC_p.name + "</td>";
  if (t.config.player_photos) {
    JC_s += '<td><img src="http://www.scrabble-assoc.com/players/' 
      + (JC_p.photo||'pix/u/unknown_player.gif').substr(4) 
      + '" width=36 height=36/></td>';
    }
  return JC_s;
  }

function JC_RenderPlayerTitle (JC_div,JC_pn) {
  var JC_p = JC_div.players[JC_pn];
  return JC_p?' title="'+JC_p.name+'"':'';
  }

function JC_RenderRoundHeaders() {
  var JC_s = '';
  var JC_r;
  JC_s += "<tr><th>#</th><th>Player</th>";
  if (t.config.player_photos) {
    JC_s += "<th>Photo</th>";
    }
  for (JC_r=1; JC_r<=t.config.max_rounds; JC_r++) {
    JC_s += "<th>Rd "+JC_r+"</th>";
    }
  JC_s += "</tr>";
  return JC_s;
  }

function JC_RenderRoundsTable(JC_cell_renderer) {
  var JC_s = '';
  var JC_div;
  var JC_p;
  var JC_pnum;
  var JC_r;
  JC_div = JC_GetDivisionByName(p.div);
  JC_s += "<table class=division>";
  JC_s += JC_RenderRoundHeaders();
  for (JC_pnum=1;JC_pnum<JC_div.players.length;JC_pnum++) {
    JC_s += "<tr>";
    JC_s += JC_RenderPlayerCells(JC_div,JC_pnum);
    JC_p = JC_div.players[JC_pnum];
    for (JC_r=1; JC_r<=t.config.max_rounds; JC_r++) {
      JC_s += JC_cell_renderer(JC_div,JC_p,JC_r);
      }
    JC_s += "</tr>";
    }
  JC_s += "</table>";
  return JC_s;
  }

function JC_RenderScoresCell(JC_div,JC_p,JC_r) {
  var JC_r0 = JC_r-1;
  var JC_s = '';
  var JC_cell = '';
  var JC_wltype = '';
  var JC_ms = JC_p.scores[JC_r0];
  var JC_on = JC_p.pairings[JC_r0];
  var JC_os;
  if (JC_on === undefined) { 
    JC_wltype = "none";
    JC_cell = "<span class=score>-</span>" 
    }
  else if (JC_on == 0) {
    JC_wltype = "bye";
    JC_cell = "<span class=bye>bye</bye>";
    }
  else { 
    JC_os = JC_div.players[JC_on].scores[JC_r0];
    if (JC_ms === undefined) { JC_ms = '?'; JC_wltype = "undefined"; }
    if (JC_os === undefined) { JC_os = '?'; JC_wltype = "undefined"; }
    if (JC_wltype === "") {
      if (JC_ms > JC_os) { JC_wltype = "win"; }
      else if (JC_ms < JC_os) { JC_wltype = "loss"; }
      else { JC_wltype = "tie"; }
      }
//  JC_cell += "<span class=score>" + JC_ms + " " + JC_os + "</span>";
    JC_cell = "<table border=0 cellpadding=0 cellspacing=0><tr><td rowspan=2 class=opp>" 
      + JC_PadPlayerNumber(JC_div,JC_on)
      + "</td>"
      + "<td class=score>" + JC_ms + "</td>"
      + "</tr><tr>"
      + "<td class=score>" + JC_os + "</td>"
      + "</tr></table>";
    }
  JC_s += "<td class=" + JC_wltype 
    + JC_RenderPlayerTitle(JC_div,JC_on)
    + ">" + JC_cell + "</td>";
  return JC_s;
  }

function JC_RenderTablesCell(JC_div,JC_p,JC_r) {
  var JC_r0 = JC_r - 1;
  var JC_b;
  var JC_oname = '';
  var JC_on = JC_p.pairings[JC_r0];
  var JC_style = 'table';
  var JC_table;
  var JC_text;

  if (JC_p.etc && JC_p.etc.board) { JC_b = JC_p.etc.board[JC_r0]; }
  if (JC_b === undefined) {
    JC_b = '?';
    JC_style = 'empty';
    }
  if (t.config.tables && t.config.tables[JC_div.name]) {
    JC_table = t.config.tables[JC_div.name][JC_b] || '?';
    }
  else {
    JC_table = '(' + JC_b + ')';
    }

  return "<td class="
    + JC_style
    + JC_RenderPlayerTitle(JC_div,JC_on)
    + '><span class=opp>'
    + JC_PadPlayerNumber(JC_div,JC_on)
    + '</span> <span class=table>'
    + JC_table
    + '</span></td>';
  }

// state 0 uninit 1 loading 2 loaded 3 interactive 4 complete
function JC_SendHTTPRequest(JC_url,JC_callback,JC_postData) {
  var JC_req = JC_XHRAlloc();
  if (!JC_req) {
    return;
    }
  var method = (JC_postData) ? "POST" : "GET";
  JC_req.open(method,JC_url,true);
  JC_req.setRequestHeader('User-Agent','XMLHTTP/1.0');
  if (JC_postData) {
    JC_req.setRequestHeader('Content-type','application/x-www-form-urlencoded');
    }
  JC_req.onreadystatechange = function () {
    if (JC_req.readyState != 4) {
      return;
      }
    if (JC_req.status != 200 && JC_req.status != 304) {
//			alert('HTTP error ' + JC_req.status);
      return;
      }
    JC_callback(JC_req);
    };
  if (JC_req.readyState == 4) {
    return;
    }
  JC_req.send(JC_postData);
  }

function JC_XHRAlloc () {
  var JC_req = JC_XHRList.pop();
  if (JC_req === undefined) {
//  alert("allocating new XHR");
    return JC_CreateXMLHTTPObject();
    }
  else {
//  alert("reusing old XHR");
    return JC_req;
    }
  }

function Update () {
  if (!(t && t.config)) {
//  statusDiv.innerHTML += "<p>No tournament data loaded.</p>";
    return;
    }
  var title = (t.config.event_name||'Unnamed event')
    + ', '
    + (t.config.event_date||'Unknown date');
  var JC_s = '<h1>' + title + '</h1>';
  document.title = title;

  // Canonicalise and default parameters
  if (p.div === undefined || p.div == '') {
    p.div = t.divisions[0].name;
    }
  if (p.mode) {
    p.mode = p.mode.toLowerCase();
    }
  else { 
    p.mode = 'scores';
    }

  JC_s += JC_RenderNavBar();
  JC_s += (JC_GetModeHandler())();

  JC_mainDiv.innerHTML = JC_s;
//statusDiv.innerHTML = "Updated.";
  }

function JC_XHRFree(JC_req) {
  JC_XHRList.push(JC_req);
  }

function JC_ZeroPad(JC_n,JC_l) {
  var JC_i;
  if (JC_n === undefined) {
    JC_n = '';
    for (JC_i=JC_l;JC_i>0;JC_i--) {
      JC_n += '?';
      }
    }
  else {
    for (JC_i=JC_l-(JC_n+'').length;JC_i>0;JC_i--) {
      JC_n = '0' + JC_n;
      }
    }
  return JC_n;
  }
EOF
  my $js2 = <<"EOF";
statusDiv = JC_GetThingByID('status');
JC_mainDiv = JC_GetThingByID('main');
EOF
  $js1 = JSCompress $js1, %$dictp;
  $js2 = JSCompress $js2, %$dictp;
  
  print <<"EOF";
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" "http://www.w3.org/TR/REC-html40/loose.dtd">
<html>
<head>
<title>tshview</title>
<link rev=made href="mailto:jjchew\@math.utoronto.ca">
<meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1">
<style type="text/css"><!--
div, h1, h2, h3, p, span, td {
  font-family: "Lucida Bright", Helvetica, sansserif;
  }
div#status, td.score {
  font-family: "Courier", monospace;
  }
span.board,
span.table,
span.opp, span.p12,
td.opp, td.score {
  font-size: 90%; 
  }
td.opp { padding-right: 0.2em; }
td.table,
td.p0,td.p3,td.p4 {
  background-color: #e0e0e0;
  }
td.p1,
td.win {
  background-color: #c0ffc0;
  }
td.p2,
td.loss {
  background-color: #ffc0c0;
  }
div.nav {
  font-size: 120%;
  padding: 0.5em 0 1em 0;
  }
div.nav span.label {
  font-weight: bold;
  background-color: #e0e0e0;
  padding: 0.2em;
  }
div.nav span.sel {
  font-weight: bold;
  }
\@media print {
  div.nav,div#status
  {display:none;}
}
--></style>
<script type="text/javascript">
$js1
</script>
</head>
<body bgcolor=white>
<noscript>
You must have JavaScript enabled to view this content.
</noscript>
<h1>tshview 1.000</h1>
<div id=status>
Loading...
</div>
<div id=main>
&nbsp;
</div>
<script type="text/javascript">
$js2
EOF
  }

sub SetUserMessageCallback ($) {
  my $tournament = shift;
  my $um = $tournament->UserMessage();
  $um->SetErrorFilter(\&UserMessageCallback);
  $um->SetNoteFilter(\&UserMessageCallback);
  $um->SetWarningFilter(\&UserMessageCallback);
  }

=item UserMessageCallback($code, $type, $message);

Callback subroutine used by UserMessage.pm.

=cut

sub UserMessageCallback ($$$) {
  my $code = shift;
  my $type = shift;
  my $message = shift;

  return if $type eq 'note';
  SendMessage $type, "$message [$code]";
  }

sub Warn ($) {
  my $message = shift;
  SendMessage 'warning', $message;
  }

=back

=head1 BUGS

=over 4

=item AskID() should give a popup list of choices.

=item Some of the code (AskID, ProcessID) is shared with showgcg.pl and should be separated out into a module.

=back

=cut
