#!/usr/bin/perl

# Copyright (C) 2008 John J. Chew, III <jjchew@math.utoronto.ca>
# All Rights Reserved

package TSH::Command::USERATINGS;

use strict;
use warnings;

use TSH::Log;
use TSH::Utility;

our (@ISA) = qw(TSH::Command);

=pod

=head1 NAME

TSH::Command::USERATINGS - implement the C<tsh> USERATINGS command

=head1 SYNOPSIS

  my $command = new TSH::Command::USERATINGS;
  my $argsp = $command->ArgumentTypes();
  my $helptext = $command->Help();
  my (@names) = $command->Names();
  $command->Run($tournament, @parsed_arguments);
  
=head1 ABSTRACT

TSH::Command::USERATINGS is a subclass of TSH::Command.

=cut

=head1 DESCRIPTION

=over 4

=cut

sub initialise ($$$$);
sub new ($);
sub Run ($$@);

=item $parserp->initialise()

Used internally to (re)initialise the object.

=cut

sub initialise ($$$$) {
  my $this = shift;
  my $path = shift;
  my $namesp = shift;
  my $argtypesp = shift;

  $this->{'help'} = <<'EOF';
Use this command to update all player ratings according to the ratings
that you have downloaded using the UPDATERATINGS command.
EOF
  $this->{'names'} = [qw(useratings)];
  $this->{'argtypes'} = [qw()];
# print "names=@$namesp argtypes=@$argtypesp\n";

  return $this;
  }

sub new ($) { return TSH::Utility::new(@_); }

=item $command->Run($tournament, @parsed_args)

Should run the command in the context of the given
tournament with the specified parsed arguments.

=cut

sub Run ($$@) { 
  my $this = shift;
  my $tournament = shift;
  my $processor = $this->Processor();
  my $config = $tournament->Config();
  my (@divisions) = $tournament->Divisions();

  my $fn = $config->MakeLibPath('ratings/nsa/current.txt');
  my $fh;
  if (!open $fh, '<', $fn) {
    $tournament->TellUser('euseropen', $fn, $!);
    return;
    }
  while (<$fh>) {
    my ($name, $rating) = split(/\t/, $_, 3);
    my (@names) = split(/\s+/, $name);
    my (@p);
    for my $i (1..$#names) {
      my $withcomma = join(' ', @names[0..$i-1]) 
        . ', ' . join(' ', @names[$i..$#names]);
      my $p = $tournament->GetPlayerByName($withcomma);
      push(@p, $p) if $p;
      }
    if (@p) {
      if (@p == 1) {
	if ($rating != $p[0]->Rating($rating)) {
	  $p[0]->Division()->Dirty(1);
	  }
        }
      else {
	$tournament->TellUser('euseramb', join(', ', map { $_->Name() } @p));
        }
      }
    }
  $tournament->UpdateDivisions();
  }

=back

=cut

=head1 BUGS

None known.

=cut


1;
