#!/usr/bin/perl

# Copyright (C) 2008 John J. Chew, III <jjchew@math.utoronto.ca>
# All Rights Reserved

package TSH::Division::Team;

use strict;
use warnings;

=pod

=head1 NAME

TSH::Division::Team - utilities for team tournaments

=head1 SYNOPSIS

  ($team1p, $team2p, ...) = TSH::Division::Team::GroupByTeam(\@players);
  print $team1p->{'members'}[0]->Name() . " belongs to team $team1p->{'name'}.\n";

=head1 ABSTRACT

This module contains utilities used at tournaments in which
players are divided into teams.

=cut

sub GroupByTeam ($);

=head1 DESCRIPTION

=over 4

=cut
 
=item $teamsp = GroupByTeam(\@players);

Given a reference to a list of players, returns a reference to a
hash mapping team name to list of references to the players belonging
to the team.

=cut

sub GroupByTeam ($) {
  my $psp = shift;
  my %teams;
  for my $p (@$psp) {
    my $team = $p->Team();
    $team = '' unless defined $team;
    push(@{$teams{$team}}, $p);
    }
  return \%teams;
  }


=head1 BUGS

None known.

=cut

1;
