#!/usr/bin/perl

# Copyright (C) 2010 John J. Chew, III <jjchew@math.utoronto.ca>
# All Rights Reserved

package Ratings::ABSP;

use strict;
use warnings;

use Ratings::ABSP;

# our (@ISA) = qw(TSH::Command);

=pod

=head1 NAME

Ratings::ABSP - code related to ABSP rating system

=head1 SYNOPSIS

  my $name = Ratings::ABSP::Canonicalise($string);
  
=head1 ABSTRACT

Ratings::ABSP contains utility functions related to the ABSP rating system.

=cut

=head1 DESCRIPTION

=over 4

=cut

my (%gNameFixes) = (
  'LAMABADUSURIYA, HARSHAN' => 'Lama\'suriya, Harshan',
  'NI BHRIAIN, BRID' => 'Ui_Bhriain, Brid',
  );

sub Canonicalise ($);

=item $name = Ratings::ABSP::Canonicalise($string);

Convert a NASPA name to WESPA form.

=cut

sub Canonicalise ($) {
  my $s = shift;
  return $gNameFixes{uc $s} || $s;
  }

=back

=cut

=head1 BUGS

The necessity of the existence of Canonicalise() is unfortunate.

=cut

1;

