#!/usr/bin/perl

# Copyright (C) 2010 John J. Chew, III <jjchew@math.utoronto.ca>
# All Rights Reserved

package Ratings::WESPA;

use strict;
use warnings;

use Ratings::WESPA;

# our (@ISA) = qw(TSH::Command);

=pod

=head1 NAME

Ratings::WESPA - code related to WESPA rating system

=head1 SYNOPSIS

  my $name = Ratings::WESPA::Canonicalise($string);
  
=head1 ABSTRACT

Ratings::WESPA contains utility functions related to the WESPA rating system.

=cut

=head1 DESCRIPTION

=over 4

=cut

my (%gNameFixes) = (
  'HOVELMEIER, TREVOR MARK' =>  'Hovelmeier, Trevor',
  'KHAN, RASHID ATEEQ'      =>  'Khan, Rasheed',
  'OLAUGHLIN, JOHN'         =>  'O\'Laughlin, John',
  'MPUNDU, PATRICK MULEMENA' =>  'Mpundu, Patrick',
  'OKWELOGU, CHINEDU NOSIKE' =>  'Okwelogu, Chinedu',
  'WEE, MING HUI HUBERT'    =>  'Ming Hui, Hubert Wee',
  'YEO, KIAN HUNG'          =>  'Kian Hung, Yeo',
  'TATE, RAYMOND'           =>  'Tate, Ray',
  'CABA, CATALIN'           =>  'Caba, Catalin-Eugen',
  'STRAWBRIDGE, CHRISTINE'  =>  'Strawb, Christine',
  'NI BHRIAIN, BRID'  =>  'Ui Bhriain, Brid',
  'LAMABADUSURIYA, HARSHAN'  =>  'Lamabad, Harshan',
  'VELLA-LAURENTI, NICKY'  =>  'Vella, Nicky',
  'BALOGUN, GBOYE'  =>  'Balogun, Alex Gboye',
  'SULAIMAN, MOHAMMAD'  =>  'Sulaiman, Mohammed',
  );

sub Canonicalise ($);

=item $name = Ratings::WESPA::Canonicalise($string);

Convert a NASPA or ABSP name to WESPA form.

=cut

sub Canonicalise ($) {
  my $s = shift;
  return $gNameFixes{uc $s} || $s;
  }

=back

=cut

=head1 BUGS

The necessity of the existence of Canonicalise() is unfortunate.

=cut

1;

