#!/usr/bin/perl

use strict;
use warnings;

use lib './lib/perl';
use lib '/Users/jjc/local/tsh/lib/perl';
use TFile;

sub Main ();
sub Munge ();

$config::pnfmt = '%03d';
Main;

sub Main () {
  @::ARGV = ('a.t') unless @::ARGV;
  my $dn = 1;
  for my $fname (@::ARGV) {
    my $tf = new TFile $fname;
    die "Can't open $fname: $!" unless $tf;
    my (@ps) = (undef);
    while (my $p = $tf->ReadLine()) {
      push(@ps, $p);
      }
    $tf->Close();
    for my $i (1..$#ps) {
      my $p = $ps[$i];
      printf "$dn-$config::pnfmt\t%d\t%s\t%s\t", 
        $i, $p->{'rating'}, (exists $p->{'etc'}{'off'} ? 'no' : 'yes'),
	$p->{'name'};
      if ($p->{'etc'}{'team'}) {
	print "$p->{'etc'}{'team'}[0]\t";
        }
      print "\n";
      }
    $dn++;
    }
  }

