#!/usr/bin/perl

# Copyright (C) 2010 John J. Chew, III <jjchew@math.utoronto.ca>
# All Rights Reserved

package Ratings::WESPA;

use strict;
use warnings;

use Ratings::WESPA;

our (@ISA) = qw(Ratings);

=pod

=head1 NAME

Ratings::WESPA - code related to WESPA rating system

=head1 SYNOPSIS

  my $name = Ratings::WESPA::Canonicalise($string);
  
=head1 ABSTRACT

Ratings::WESPA contains utility functions related to the WESPA rating system.

=cut

=head1 DESCRIPTION

=over 4

=cut

my (%gNameFixes) = (
  'ANANGA, YAWO' => 'Ananga, Yawo Takyi',
  'BALOGUN, GBOYE' => 'Balogun, Alex Gboye',
  'CABA, CATALIN' => 'Caba, Catalin-Eugen',
  'CARTER, GERALD' => 'Carter, Gerry',
# 'CHEAH, SIU HEAN' => 'Hean, Cheah Siu',
  'DE CASTRO, PHYLLIS' => 'DeCastro, Phyllis',
  'FRENDO, PAUL' => 'Frendo, Pawlu',
  'GOLDMAN, STUART' => 'Goldman, Stu',
  'HOVELMEIER, TREVOR MARK' => 'Hovelmeier, Trevor',
  'ILORI, OLAWALE' => 'Ilori, Wale',
  'KHAN, RASHID ATEEQ' => 'Khan, Rasheed',
  'LAMABADUSURIYA, HARSHAN' => 'Lamabad, Harshan',
# 'LIEW, KIAN BOON' => 'Boon, Liew Kian',
  'LIM, SHALYN' => 'Lim, Sha Lyn',
# 'MORRIS, PAM' => 'Morris, Pamela',
  'MPUNDU, PATRICK MULEMENA' => 'Mpundu, Patrick',
  'NELKON, PHILIP' => 'Nelkon, Phil',
# 'NI BHRIAIN, BRID' => 'Bhriain, Brid Ui',
  'NI BHRIAIN, BRID' => 'O\'Brien, Breda',
  'OKWELOGU, CHINEDU NOSIKE' => 'Okwelogu, Chinedu',
  'OLAUGHLIN, JOHN' => 'O\'Laughlin, John',
  'ONG, SUANNE' => 'Suanne, Ong',
  'PUTTICK, JUDY' => 'Puttick, Judith',
  'RIO, ODETTE CARMINA' => 'Rio, Odette',
  'SHIM, YEN NEE' => 'Nee, Shim Yen',
  'STRAWBRIDGE, CHRISTINE' => 'Strawb, Christine',
# 'SULAIMAN, MOHAMMAD' => 'Sulaiman, Mohammed',
  'TALBOT, RODNEY' => 'Talbot, Rod',
# 'TAN, JIN CHOR' => 'Chor, Tan Jin',
  'TATE, RAYMOND' => 'Tate, Ray',
  'TOH, WEIBIN' => 'Weibin, Toh',
  'VELLA-LAURENTI, NICKY' => 'Vella, Nicky',
  'VELLA LAURENTI, NICKY' => 'Vella, Nicky',
  'WEE, MING HUI HUBERT' => 'Wee, Hubert',
  'WEE, HUBERT MING HUI' => 'Wee, Hubert',
  'WIEGAND, DAVE' => 'Wiegand, David',
  'YEO, KIEN HUNG' => 'Yeo, Kian Hung',
  'USAKIEWICZ, WOJTEK' => 'Usakiewicz, Wojciech',
# 'ZXQKJ, WINTER' => 'Winter',

  'KRAMER, JIM' => 'Kramer, James',
  'CAVENAGH, NICHOLAS' => 'Cavenagh, Nick',
  'WANNIARACHCHI, LAKSHAN' => 'Wanni, Lakshan',
  'ADAMSON, TIM' => 'Adamson, Timothy',
  'ADDO-QUAYE, GEORGE' => 'Addo, George',
  'ASSARAT, SUTHIRAPAN' => 'Assarat, Suthiraphan',
  'BARAMEEMUANG, THITIPOL' => 'Barameem, Thitipol',
  'BASSETT-BOUCHARD, CONRAD' => 'BB, Conrad',
  'BOONSIRIPHAN, SITTHICHOKE' => 'Boonsiri, Sitthicok',
  'CHINRUNGROJ, NATTAWUTH' => 'Chinrung, Nattawuth',
  'DANIEL, ROBIN POLLOCK' => 'Daniel, Robin',
  'EDWIN-MUGISHA, PHILLIP' => 'Edwin-Mugish, Phillip',
  'ITTHI-AREE, CHOLLAPAT' => 'Itthiaree, Chollapat',
  'KHONGTHANARAT, CHARNRIT' => 'Khongthan, Charnrit',
  'KHONGTHANARAT, PREEDEE' => 'Khongthanara, Preedee',
  'KHWANSAK, AKKARAPOL' => 'Kwhansak, Akkarapol',
  'KUKIETTIKULCHAI, THANAPONG' => 'Kukiet, Thanapong',
  'METHASET, ARUN' => 'Methaseth, Arun',
  'MOOLASARN, PHUTTAPHONG' => 'Moolasar, Phuttaphong',
  'PAEPOLSIRI, TAWAN' => 'Paepholsiri, Tawan',
  'PANYASOPHONLERT, KOMOL' => 'Panyasoponlert, Komol',
  'PHIPHATBOONSERM, MANOP' => 'Phiphat, Manop',
  'SOSSEH, ABRAHAM EBI' => 'Sosseh, Abraham',
  'SUKHUMRATTANAPORN, CHARNWIT' => 'Sukhu, Charnwit',
  'SUKSANSUMRAN, WORASIT' => 'Suksaensam, Worasit',
  'SUPHAPHIBUNKUN, TANASAK' => 'Supaphibunk, Tanasak',
  'SUPPAPITTATORN, AKARADECH' => 'Suppapittatorn, Akaradech',
  'TANASANVIMOL, MANEEDA' => 'Tanasarn, Maneeda',
  'TANASANVIMOL, WEERANEE' => 'Tanasarn, Weeranee',
  'THIENKAROJANAKUL, KAMOL' => 'Tienkarojan, Kamol',
  'THIVAVARNVONGS, THAVACHAI' => 'Tivava, Thavachai',
  'TREEPOONSUK, NUT' => 'Treepoonsuk, Nutt',
  'TRITIPTHANAKUL, PACHARA' => 'Tritipthanak, Pachara',
  'VICARY, CHRISTOPHER' => 'Vicary, Chris',
  'VONGTHANASOONTHORN, VISAN' => 'Vongthanasun, Visan',
  'WUTHINITIKORNKIT, CHAIWAT' => 'Wuthinitikor, Chaiwat',
# 'SRICHAWLA, DANIEL' => 'Srichwala, Daniel',
# 'WORAPOTPISUT, CHARAE' => 'Worapotpisut, Charae',
#   'WORAPOTPISUT, CHARAS' => 'Worapot, Charas',
  );

sub Canonicalise ($);

=item $name = Ratings::WESPA::Canonicalise($string);

Convert a NASPA or ABSP name to WESPA form.

=cut

sub Canonicalise ($) {
  my $s = shift;
  my $canon = $gNameFixes{uc $s} || $s;
  return $canon;
  }

=back

=cut

=head1 BUGS

The necessity of the existence of Canonicalise() is unfortunate.

=cut

1;

