#!/usr/bin/perl

# Copyright (C) 2010 John J. Chew, III <jjchew@math.utoronto.ca>
# All Rights Reserved

package TSH::ReportCommand::ExtremeGames;

use strict;
use warnings;
use threads::shared;
use TSH::Log;
use TSH::Utility;
use Carp;
use TSH::ReportCommand;

our (@ISA) = qw(TSH::ReportCommand);

=pod

=head1 NAME

TSH::ReportCommand::ExtremeGames - common code for commands that report on extreme games

=head1 SYNOPSIS

This subclass supports features common to commands that report on
extreme games (high win, high loss, etc.).
  
=head1 ABSTRACT

$rc->FindEntries();

=cut

=head1 DESCRIPTION

=over 4

=cut

sub FindEntries ($) {
  my $this = shift;
  $this->{'rcopt'}{'entries'} = TSH::Division::FindExtremeGames::Search(
    $this->{'rcopt'}{'dp'},
    $this->{'rcopt'}{'max_entries'},
    $this->{'rcopt'}{'selector'},
    $this->{'rcopt'}{'comparator'},
    );
  }

=back

=cut

=head1 BUGS

None reported.

=cut

